/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.impl.HelpCommand;

class CommandFactory {
    private static final String CONFIG_COMMAND_ENTRY = "jmxterm.commands.";
    private static final String CONFIG_COMMAND_TYPE_SUFFIX = ".type";
    private static final String CONFIG_PATH = "META-INF/cyclopsgroup/jmxterm.properties";
    final Map<String, Class<? extends Command>> commandTypes;

    CommandFactory() throws ClassNotFoundException, IOException {
        this(CONFIG_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CommandFactory(String configPath) throws ClassNotFoundException, IOException {
        Validate.notNull((Object)configPath, (String)"configPath can't be NULL");
        Properties props = new Properties();
        ClassLoader classLoader = this.getClass().getClassLoader();
        Enumeration<URL> configs = classLoader.getResources(configPath);
        while (configs.hasMoreElements()) {
            InputStream in = configs.nextElement().openStream();
            try {
                props.load(in);
            }
            finally {
                in.close();
            }
        }
        HashMap commands = new HashMap();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String name = (String)entry.getKey();
            if (!name.startsWith(CONFIG_COMMAND_ENTRY) || !name.endsWith(CONFIG_COMMAND_TYPE_SUFFIX)) continue;
            String commandConfig = name.substring(0, name.length() - CONFIG_COMMAND_TYPE_SUFFIX.length());
            String commandName = commandConfig.substring(CONFIG_COMMAND_ENTRY.length());
            Class<?> commandType = classLoader.loadClass((String)entry.getValue());
            commands.put(commandName, commandType);
            String aliases = props.getProperty(commandConfig + ".alias");
            if (!StringUtils.isNotEmpty((String)aliases)) continue;
            for (String alias : StringUtils.split((String)aliases, (char)',')) {
                commands.put(alias, commandType);
            }
        }
        commands.put("help", HelpCommand.class);
        this.commandTypes = Collections.unmodifiableMap(commands);
    }

    Command createCommand(String commandName) throws InstantiationException, IllegalAccessException, IllegalArgumentException {
        Validate.notNull((Object)commandName, (String)"commandName can't be NULL");
        Class<? extends Command> commandType = this.commandTypes.get(commandName);
        if (commandType == null) {
            throw new IllegalArgumentException("Command " + commandName + " isn't valid, run help to see available commands");
        }
        return commandType.newInstance();
    }
}

