/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm;

import java.io.IOException;
import java.util.List;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cyclopsgroup.jmxterm.ExtendedPropertiesUtils;
import org.cyclopsgroup.jmxterm.JavaProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaProcessManager {
    private static final JavaProcessManager INSTANCE;
    private static final Log LOG;
    private String description;
    private String name;

    private static JavaProcessManager createInstance() throws IOException {
        ExtendedProperties extProps = ExtendedPropertiesUtils.loadFromOverlappingResources("META-INF/cyclopsgroup/jmxterm.properties", JavaProcessManager.class.getClassLoader());
        extProps = extProps.subset("jmxterm.jpm");
        String[] names = extProps.getStringArray("name");
        ClassLoader classLoader = JavaProcessManager.class.getClassLoader();
        JavaProcessManager jpm = null;
        for (String name : names) {
            String type = extProps.getString(name + ".type");
            String description = extProps.getString(name + ".description");
            try {
                jpm = (JavaProcessManager)classLoader.loadClass(type).newInstance();
                jpm.setName(name);
                jpm.setDescription(description);
                break;
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return jpm;
    }

    public static JavaProcessManager getInstance() {
        if (INSTANCE == null) {
            throw new UnsupportedOperationException("Java environment doesn't support this feature");
        }
        return INSTANCE;
    }

    public abstract JavaProcess get(int var1) throws Exception;

    public final String getDescription() {
        return this.description;
    }

    public final String getName() {
        return this.name;
    }

    public abstract List<JavaProcess> list();

    private void setDescription(String description) {
        this.description = description;
    }

    private void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        LOG = LogFactory.getLog(JavaProcessManager.class);
        JavaProcessManager jpm = null;
        try {
            jpm = JavaProcessManager.createInstance();
        }
        catch (IOException e) {
            LOG.error((Object)"JavaProcessManager couldn't be initialized", (Throwable)e);
        }
        finally {
            INSTANCE = jpm;
        }
    }
}

