/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jmxterm.Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Session {
    private boolean abbreviated;
    private String bean;
    private boolean closed;
    private String domain;
    public final PrintWriter output;
    private boolean verbose;

    public Session(PrintWriter output) {
        Validate.notNull((Object)output, (String)"Output can't be NULL");
        this.output = output;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    public abstract void connect(JMXServiceURL var1, Map<String, Object> var2) throws IOException;

    public abstract void disconnect() throws IOException;

    public final String getBean() {
        return this.bean;
    }

    public abstract Connection getConnection();

    public final String getDomain() {
        return this.domain;
    }

    public final boolean isAbbreviated() {
        return this.abbreviated;
    }

    public final boolean isClosed() {
        return this.closed;
    }

    public abstract boolean isConnected();

    public final boolean isVerbose() {
        return this.verbose;
    }

    public void msg(String msg) {
        this.msg(msg, null);
    }

    public void msg(String msg, String abbr) {
        if (this.abbreviated) {
            if (StringUtils.isNotEmpty((String)abbr)) {
                this.output.println(abbr);
            }
        } else if (StringUtils.isNotEmpty((String)msg)) {
            this.output.println(msg);
        }
    }

    public void ok() {
        if (this.abbreviated) {
            this.output.println("ok");
        }
    }

    public final void setAbbreviated(boolean abbreviated) {
        this.abbreviated = abbreviated;
    }

    public final void setBean(String bean) {
        this.bean = bean;
    }

    public final void setDomain(String domain) {
        Validate.notNull((Object)domain, (String)"domain can't be NULL");
        this.domain = domain;
    }

    public final void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void unsetDomain() {
        this.bean = null;
        this.domain = null;
    }
}

