/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jcli.annotation.Argument;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.SyntaxUtils;
import org.cyclopsgroup.jmxterm.cmd.DomainCommand;

@Cli(name="bean", description="Display or set current selected MBean")
public class BeanCommand
extends Command {
    private static final String STRING_PATTERN_PROPERTIES = "\\w+\\=.+(\\,\\w+\\=.+)*";
    private static final Pattern PATTERN_PROPERTIES = Pattern.compile("^\\w+\\=.+(\\,\\w+\\=.+)*$");
    private static final Pattern PATTERN_BEAN_NAME = Pattern.compile("^(\\w|\\.)+\\:\\w+\\=.+(\\,\\w+\\=.+)*$");
    private String bean;
    private String domain;

    @Option(name="d", longName="domain", description="Domain name")
    public final void setDomain(String domain) {
        this.domain = domain;
    }

    @Argument
    public final void setBean(String bean) {
        this.bean = bean;
    }

    public static String getBeanName(String bean, String domain, Session session) throws JMException, IOException {
        Validate.notNull((Object)session, (String)"Session can't be NULL");
        if (bean == null) {
            return session.getBean();
        }
        if (SyntaxUtils.isNull(bean)) {
            return null;
        }
        MBeanServerConnection con = session.getConnection().getServerConnection();
        if (PATTERN_BEAN_NAME.matcher(bean).find()) {
            ObjectName name = new ObjectName(bean);
            con.getMBeanInfo(name);
            return bean;
        }
        String domainName = DomainCommand.getDomainName(domain, session);
        if (domainName == null) {
            throw new IllegalArgumentException("Please specify domain using either -d option or domain command");
        }
        if (PATTERN_PROPERTIES.matcher(bean).find()) {
            return domainName + ":" + bean;
        }
        throw new IllegalArgumentException("Bean name " + bean + " isn't valid");
    }

    public void execute(Session session) throws IOException, JMException {
        if (this.bean == null) {
            if (session.getBean() == null) {
                session.msg("bean is not set", "null");
            } else {
                session.msg("bean = " + session.getBean(), session.getBean());
            }
            return;
        }
        String beanName = BeanCommand.getBeanName(this.bean, this.domain, session);
        if (beanName == null) {
            session.setBean(null);
            session.msg("bean is unset", "ok");
            return;
        }
        ObjectName name = new ObjectName(beanName);
        MBeanServerConnection con = session.getConnection().getServerConnection();
        con.getMBeanInfo(name);
        session.setBean(beanName);
        session.msg("bean is set to " + beanName, "ok");
    }
}

