/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jcli.annotation.Argument;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.SyntaxUtils;
import org.cyclopsgroup.jmxterm.cmd.DomainsCommand;

@Cli(name="domain", description="Display or set current selected domain")
public class DomainCommand
extends Command {
    private String domain;

    public static String getDomainName(String domain, Session session) throws IOException {
        Validate.notNull((Object)session, (String)"Session can't be NULL");
        Validate.isTrue((session.getConnection() != null ? 1 : 0) != 0, (String)"Session isn't opened");
        if (domain == null) {
            return session.getDomain();
        }
        if (SyntaxUtils.isNull(domain)) {
            return null;
        }
        HashSet<String> domains = new HashSet<String>(DomainsCommand.getDomains(session));
        if (!domains.contains(domain)) {
            throw new IllegalArgumentException("Domain " + domain + " doesn't exist, check your spelling");
        }
        return domain;
    }

    public void execute(Session session) throws IOException {
        Validate.notNull((Object)session, (String)"Session can't be NULL");
        if (this.domain == null) {
            if (session.getDomain() == null) {
                session.msg("domain is not set", "null");
            } else {
                session.msg("domain = " + session.getDomain(), session.getDomain());
            }
            return;
        }
        String domainName = DomainCommand.getDomainName(this.domain, session);
        if (domainName == null) {
            session.unsetDomain();
            session.msg("domain is unset", "ok");
        } else {
            session.setDomain(domainName);
            session.msg("domain is set to " + session.getDomain(), "ok");
        }
    }

    @Argument
    public final void setDomain(String domain) {
        this.domain = domain;
    }
}

