/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.util.HashMap;
import org.apache.commons.lang.math.NumberUtils;
import org.cyclopsgroup.jcli.annotation.Argument;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Connection;
import org.cyclopsgroup.jmxterm.JavaProcess;
import org.cyclopsgroup.jmxterm.JavaProcessManager;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.SyntaxUtils;

@Cli(name="open", description="Open JMX session", note="URL can be a <PID>, <hostname>:<port> or full qualified JMX service URL. For example\n open localhost:9991,\n open jmx:service:...")
public class OpenCommand
extends Command {
    private String password;
    private String url;
    private String user;

    private static String tryGettingUrlForPid(int pid) throws Exception {
        JavaProcess p = JavaProcessManager.getInstance().get(pid);
        if (p == null) {
            throw new NullPointerException("No such PID " + pid);
        }
        if (!p.isManageable()) {
            p.startManagementAgent();
            if (!p.isManageable()) {
                throw new IllegalStateException("Managed agent for PID " + pid + " couldn't start. PID " + pid + " is not manageable");
            }
        }
        return p.toUrl();
    }

    public void execute(Session session) throws Exception {
        HashMap<String, Object> env;
        if (this.url == null) {
            Connection con = session.getConnection();
            if (con == null) {
                session.msg("not connected", "null");
            } else {
                session.output.println(String.format(session.isAbbreviated() ? "%s,%s" : "connected to: id=%s, url=%s", con.getConnectorId(), con.getUrl()));
            }
            return;
        }
        if (this.user != null) {
            env = new HashMap<String, Object>(1);
            String[] credentials = new String[]{this.user, this.password};
            env.put("jmx.remote.credentials", credentials);
        } else {
            env = null;
        }
        String u = NumberUtils.isDigits((String)this.url) ? OpenCommand.tryGettingUrlForPid(Integer.parseInt(this.url)) : this.url;
        session.connect(SyntaxUtils.getUrl(u), env);
        session.msg("Connection to " + this.url + " is opened", "ok");
    }

    @Option(name="p", longName="password", description="Password for user/password authentication")
    public final void setPassword(String password) {
        this.password = password;
    }

    @Argument
    public final void setUrl(String url) {
        this.url = url;
    }

    @Option(name="u", longName="user", description="User name for user/password authentication")
    public final void setUser(String user) {
        this.user = user;
    }
}

