/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jcli.annotation.Argument;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.SyntaxUtils;
import org.cyclopsgroup.jmxterm.cmd.BeanCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cli(name="set", description="Set value of an MBean attribute")
public class SetCommand
extends Command {
    private List<String> arguments = Collections.emptyList();
    private String bean;
    private String domain;

    @Override
    public void execute(Session session) throws JMException, IOException {
        Validate.isTrue((this.arguments.size() >= 2 ? 1 : 0) != 0, (String)"At least two arguments are required");
        String attributeName = this.arguments.get(0);
        String beanName = BeanCommand.getBeanName(this.bean, this.domain, session);
        ObjectName name = new ObjectName(beanName);
        MBeanServerConnection con = session.getConnection().getServerConnection();
        MBeanInfo beanInfo = con.getMBeanInfo(new ObjectName(beanName));
        MBeanAttributeInfo attributeInfo = null;
        for (MBeanAttributeInfo i : beanInfo.getAttributes()) {
            if (!i.getName().equals(attributeName)) continue;
            attributeInfo = i;
            break;
        }
        if (attributeInfo == null) {
            throw new IllegalArgumentException("Attribute " + attributeName + " is not sepcified");
        }
        if (!attributeInfo.isWritable()) {
            throw new IllegalArgumentException("Attribute " + attributeName + " is not writable");
        }
        Object value = SyntaxUtils.parse(this.arguments.get(1), attributeInfo.getType());
        con.setAttribute(name, new Attribute(attributeName, value));
        session.msg("Value of attribute " + attributeName + " is set to " + value, "ok");
    }

    @Argument(requires=2, description="name, value, value2...")
    public final void setArguments(List<String> arguments) {
        Validate.notNull(arguments, (String)"Arguments can't be NULL");
        this.arguments = arguments;
    }

    @Option(name="b", longName="bean", description="MBean name where the attribute is. Optional if bean has been set")
    public final void setBean(String bean) {
        this.bean = bean;
    }

    @Option(name="d", longName="domain", description="Domain under which the bean is")
    public final void setDomain(String domain) {
        this.domain = domain;
    }
}

