/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.impl;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Parser;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jcli.QuotedStringTokenizer;
import org.cyclopsgroup.jcli.annotation.CliParser;
import org.cyclopsgroup.jcli.jccli.JakartaCommonsCliParser;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.CommandFactory;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.impl.ConnectionAwareSession;
import org.cyclopsgroup.jmxterm.impl.HelpCommand;
import org.cyclopsgroup.jmxterm.impl.PredefinedCommandFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCenter {
    private static final String COMMAND_DELIMITER = "&&";
    private final CliParser cliParser = new JakartaCommonsCliParser((Parser)new GnuParser());
    private final CommandFactory commandFactory;
    private final Lock lock = new ReentrantLock();
    private final Session session;
    private final QuotedStringTokenizer argTokenizer = new QuotedStringTokenizer();

    public CommandCenter(PrintWriter output) throws IOException, ClassNotFoundException {
        this(output, new PredefinedCommandFactory());
    }

    public CommandCenter(PrintWriter output, CommandFactory commandFactory) {
        Validate.notNull((Object)output, (String)"Output can't be NULL");
        Validate.notNull((Object)commandFactory, (String)"Command factory can't be NULL");
        this.session = new ConnectionAwareSession(output);
        this.commandFactory = commandFactory;
        this.session.msg("Welcome to JMX terminal. Type \"help\" for available commands.");
    }

    public void close() {
        this.session.close();
    }

    public void connect(JMXServiceURL url, Map<String, Object> env) throws IOException {
        Validate.notNull((Object)url, (String)"URL can't be NULL");
        this.session.connect(url, env);
    }

    private void doExecute(String command) throws Exception {
        if ((command = StringUtils.trimToNull((String)command)) == null) {
            return;
        }
        if (command.startsWith("#")) {
            return;
        }
        int commandEnds = command.indexOf(35);
        if (commandEnds != -1) {
            command = command.substring(0, commandEnds);
        }
        if (command.indexOf(COMMAND_DELIMITER) != -1) {
            String[] commands;
            for (String c : commands = StringUtils.split((String)command, (String)COMMAND_DELIMITER)) {
                this.execute(c);
            }
            return;
        }
        String[] args = this.argTokenizer.parse(command).toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        String commandName = args[0];
        String[] commandArgs = new String[args.length - 1];
        System.arraycopy(args, 1, commandArgs, 0, args.length - 1);
        this.doExecute(commandName, commandArgs);
    }

    void printUsage(Class<? extends Command> commandType) throws IntrospectionException {
        this.cliParser.printUsage(commandType, this.session.output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute(String commandName, String[] commandArgs) throws Exception {
        Command cmd = this.commandFactory.createCommand(commandName);
        if (cmd instanceof HelpCommand) {
            ((HelpCommand)cmd).setCommandCenter(this);
        }
        this.cliParser.parse(commandArgs, (Object)cmd);
        if (cmd.isHelp()) {
            this.printUsage(cmd.getClass());
            return;
        }
        this.lock.lock();
        try {
            cmd.execute(this.session);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void execute(String command) {
        try {
            this.doExecute(command);
        }
        catch (Exception e) {
            if (this.session.isVerbose()) {
                e.printStackTrace(this.session.output);
            }
            this.session.output.println(e.getClass().getSimpleName() + ":" + e.getMessage());
        }
    }

    public Set<String> getCommandNames() {
        return this.commandFactory.getCommandTypes().keySet();
    }

    public Class<? extends Command> getCommandType(String name) {
        return this.commandFactory.getCommandTypes().get(name);
    }

    public boolean isClosed() {
        return this.session.isClosed();
    }

    public void prompt() throws IOException {
        if (!this.session.isAbbreviated()) {
            this.session.output.print((this.session.isConnected() ? ">" : "?") + "$ ");
            this.session.output.flush();
        }
    }

    public void setAbbreviated(boolean abbreviated) {
        this.session.setAbbreviated(abbreviated);
    }
}

