/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.CommandFactory;
import org.cyclopsgroup.jmxterm.ExtendedPropertiesUtils;
import org.cyclopsgroup.jmxterm.impl.HelpCommand;
import org.cyclopsgroup.jmxterm.impl.TypeMapCommandFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PredefinedCommandFactory
implements CommandFactory {
    private final CommandFactory delegate;

    PredefinedCommandFactory() throws ClassNotFoundException, IOException {
        this("META-INF/cyclopsgroup/jmxterm.properties");
    }

    public PredefinedCommandFactory(String configPath) throws ClassNotFoundException, IOException {
        Validate.notNull((Object)configPath, (String)"configPath can't be NULL");
        ClassLoader classLoader = this.getClass().getClassLoader();
        ExtendedProperties props = ExtendedPropertiesUtils.loadFromOverlappingResources(configPath, classLoader);
        props = props.subset("jmxterm.commands");
        HashMap<String, Class<? extends Command>> commands = new HashMap<String, Class<? extends Command>>();
        for (String name : props.getStringArray("name")) {
            String type = props.getString(name + ".type");
            Class<?> commandType = classLoader.loadClass(type);
            commands.put(name, commandType);
            Object[] aliases = props.getStringArray(name + ".alias");
            if (ArrayUtils.isEmpty((Object[])aliases)) continue;
            for (Object alias : aliases) {
                commands.put((String)alias, commandType);
            }
        }
        commands.put("help", HelpCommand.class);
        this.delegate = new TypeMapCommandFactory(commands);
    }

    @Override
    public Command createCommand(String commandName) throws Exception {
        return this.delegate.createCommand(commandName);
    }

    @Override
    public Map<String, Class<? extends Command>> getCommandTypes() {
        return this.delegate.getCommandTypes();
    }
}

