/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.impl;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.CommandFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMapCommandFactory
implements CommandFactory {
    private final Map<String, Class<? extends Command>> commandTypes;

    public TypeMapCommandFactory(Map<String, Class<? extends Command>> commandTypes) {
        Validate.notNull(commandTypes, (String)"Command type can't be NULL");
        this.commandTypes = Collections.unmodifiableMap(commandTypes);
    }

    @Override
    public Command createCommand(String commandName) throws InstantiationException, IllegalAccessException, IllegalArgumentException {
        Validate.notNull((Object)commandName, (String)"commandName can't be NULL");
        Class<? extends Command> commandType = this.commandTypes.get(commandName);
        if (commandType == null) {
            throw new IllegalArgumentException("Command " + commandName + " isn't valid, run help to see available commands");
        }
        return commandType.newInstance();
    }

    @Override
    public Map<String, Class<? extends Command>> getCommandTypes() {
        return this.commandTypes;
    }
}

