/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import javax.management.openmbean.CompositeData;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.cyclopsgroup.jmxterm.JavaProcess;
import org.cyclopsgroup.jmxterm.JavaProcessManager;

public final class SyntaxUtils {
    public static final String NULL = "null";
    public static final String OK = "ok";
    private static final Pattern PATTERN_HOST_PORT = Pattern.compile("^(\\w|\\.|\\-)+\\:\\d+$");

    public static JMXServiceURL getUrl(String url) throws Exception {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException("Empty URL is not allowed");
        }
        if (NumberUtils.isDigits((String)url)) {
            Integer pid = Integer.parseInt(url);
            JavaProcess p = JavaProcessManager.getInstance().get(pid);
            if (p == null) {
                throw new NullPointerException("No such PID " + pid);
            }
            if (!p.isManageable()) {
                p.startManagementAgent();
                if (!p.isManageable()) {
                    throw new IllegalStateException("Managed agent for PID " + pid + " couldn't start. PID " + pid + " is not manageable");
                }
            }
            return new JMXServiceURL(p.toUrl());
        }
        if (PATTERN_HOST_PORT.matcher(url).find()) {
            return new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + url + "/jmxrmi");
        }
        return new JMXServiceURL(url);
    }

    public static boolean isNull(String s) {
        return StringUtils.equalsIgnoreCase((String)NULL, (String)s) || StringUtils.equals((String)"*", (String)s);
    }

    public static Object parse(String expression, String type) {
        Class c;
        if (StringUtils.isEmpty((String)expression) || SyntaxUtils.isNull(expression)) {
            return null;
        }
        try {
            c = ClassUtils.getClass((String)type);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Type " + type + " isn't valid", e);
        }
        return ConvertUtils.convert((String)expression, (Class)c);
    }

    public static void printExpression(PrintWriter output, Object name, Object value, String description, int indent, boolean showDescription) {
        output.print(StringUtils.repeat((String)" ", (int)indent));
        SyntaxUtils.printValue(output, name, indent, showDescription);
        output.print(" = ");
        SyntaxUtils.printValue(output, value, indent, showDescription);
        output.print(";");
        if (showDescription && description != null) {
            output.print(" (" + description + ")");
        }
        output.println();
    }

    public static void printValue(PrintWriter output, Object value, int indent, boolean showDescription) {
        if (value == null) {
            output.print(NULL);
        } else if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            output.print("[ ");
            for (int i = 0; i < length; ++i) {
                if (i != 0) {
                    output.print(", ");
                }
                SyntaxUtils.printValue(output, Array.get(value, i), indent, showDescription);
            }
            output.print(" ]");
        } else if (Collection.class.isAssignableFrom(value.getClass())) {
            boolean start = true;
            output.print("( ");
            for (Object obj : (Collection)value) {
                if (!start) {
                    output.print(", ");
                }
                start = false;
                SyntaxUtils.printValue(output, obj, indent, showDescription);
            }
            output.print(" )");
        } else if (Map.class.isAssignableFrom(value.getClass())) {
            output.println("{ ");
            for (Map.Entry entry : ((Map)value).entrySet()) {
                SyntaxUtils.printExpression(output, entry.getKey(), entry.getValue(), null, indent + 2, showDescription);
            }
            output.print(StringUtils.repeat((String)" ", (int)indent) + " }");
        } else if (CompositeData.class.isAssignableFrom(value.getClass())) {
            output.println("{ ");
            CompositeData data = (CompositeData)value;
            for (String key : data.getCompositeType().keySet()) {
                Object v = data.get(key);
                SyntaxUtils.printExpression(output, key, v, data.getCompositeType().getDescription(key), indent + 2, showDescription);
            }
            output.print(StringUtils.repeat((String)" ", (int)indent) + " }");
        } else if (value instanceof String) {
            output.print("\"" + value + "\"");
        } else {
            output.print(value);
        }
    }

    private SyntaxUtils() {
    }
}

