/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.boot;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import jline.Completor;
import jline.ConsoleReader;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Parser;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jcli.jccli.JakartaCommonsCliParser;
import org.cyclopsgroup.jmxterm.SyntaxUtils;
import org.cyclopsgroup.jmxterm.boot.CommandInput;
import org.cyclopsgroup.jmxterm.boot.FileCommandInput;
import org.cyclopsgroup.jmxterm.boot.JlineCommandInput;
import org.cyclopsgroup.jmxterm.boot.MainOptions;
import org.cyclopsgroup.jmxterm.impl.CommandCenter;
import org.cyclopsgroup.jmxterm.impl.ConsoleCompletor;

public class Main {
    private static final PrintWriter STDOUT_WRITER = new PrintWriter(System.out, true);
    private final CommandCenter commandCenter;

    Main(CommandCenter commandCenter) {
        Validate.notNull((Object)commandCenter, (String)"CommandCenter can't be NULL");
        this.commandCenter = commandCenter;
    }

    private Main() throws IOException, ClassNotFoundException {
        this(new CommandCenter(STDOUT_WRITER));
    }

    public static final void main(String[] args) throws Exception {
        System.exit(new Main().execute(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int execute(String[] args) throws Exception {
        OutputStreamWriter output;
        MainOptions options = new MainOptions();
        JakartaCommonsCliParser parser = new JakartaCommonsCliParser((Parser)new GnuParser());
        parser.parse(args, (Object)options);
        if (options.isHelp()) {
            parser.printUsage(MainOptions.class, STDOUT_WRITER);
            return 0;
        }
        this.commandCenter.setAbbreviated(options.isAbbreviated());
        if (StringUtils.equals((String)options.getOutput(), (String)"stdout")) {
            output = new OutputStreamWriter(System.out){

                public void close() throws IOException {
                }
            };
        } else {
            File outputFile = new File(options.getOutput());
            output = new FileWriter(outputFile);
        }
        ConsoleReader consoleReader = new ConsoleReader(System.in, (Writer)output);
        consoleReader.addCompletor((Completor)new ConsoleCompletor(this.commandCenter));
        if (options.getUrl() != null) {
            HashMap<String, Object> env;
            if (options.getUser() != null) {
                env = new HashMap<String, Object>(1);
                String password = options.getPassword();
                if (password == null) {
                    password = consoleReader.readLine("password:", Character.valueOf('*'));
                }
                String[] credentials = new String[]{options.getUser(), password};
                env.put("jmx.remote.credentials", credentials);
            } else {
                env = null;
            }
            this.commandCenter.connect(SyntaxUtils.getUrl(options.getUrl()), env);
        }
        CommandInput input = options.getInput().equals("stdin") ? new JlineCommandInput(consoleReader, "$>") : new FileCommandInput(new File(options.getInput()));
        try {
            String line;
            int exitCode = 0;
            int lineNumber = 0;
            while ((line = input.readLine()) != null) {
                ++lineNumber;
                if (!this.commandCenter.execute(line) && options.isExitOnFailure()) {
                    exitCode = -lineNumber;
                    break;
                }
                if (!this.commandCenter.isClosed()) continue;
            }
            this.commandCenter.close();
            int n = exitCode;
            return n;
        }
        finally {
            ((Writer)output).flush();
            ((Writer)output).close();
            input.close();
        }
    }
}

