/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cli(name="domains", description="List all available domain names")
public class DomainsCommand
extends Command {
    static List<String> getCandidateDomains(Session session) throws IOException {
        String[] domains = session.getConnection().getServerConnection().getDomains();
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(domains));
        Collections.sort(result);
        return result;
    }

    @Override
    public void execute() throws IOException {
        Session session = this.getSession();
        if (!session.isAbbreviated()) {
            session.msg("following domains are available");
        }
        int i = 0;
        for (String domain : DomainsCommand.getCandidateDomains(session)) {
            session.msg(String.format("%%%-3d - %s", i++, domain), domain);
        }
    }
}

