/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.util.HashMap;
import org.cyclopsgroup.jcli.annotation.Argument;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Connection;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.SyntaxUtils;

@Cli(name="open", description="Open JMX session or display current connection", note="Without argument this command display current connection. URL can be a <PID>, <hostname>:<port> or full qualified JMX service URL. For example\n open localhost:9991,\n open jmx:service:...")
public class OpenCommand
extends Command {
    private String password;
    private String url;
    private String user;

    public void execute() throws Exception {
        HashMap<String, Object> env;
        Session session = this.getSession();
        if (this.url == null) {
            Connection con = session.getConnection();
            if (con == null) {
                session.msg("not connected", "null");
            } else {
                session.output.println(String.format(session.isAbbreviated() ? "%s,%s" : "connected to: id=%s, url=%s", con.getConnectorId(), con.getUrl()));
            }
            return;
        }
        if (this.user != null) {
            if (this.password == null) {
                // empty if block
            }
            env = new HashMap<String, Object>(1);
            String[] credentials = new String[]{this.user, this.password};
            env.put("jmx.remote.credentials", credentials);
        } else {
            env = null;
        }
        session.connect(SyntaxUtils.getUrl(this.url), env);
        session.msg("Connection to " + this.url + " is opened", "ok");
    }

    @Option(name="p", longName="password", description="Password for user/password authentication")
    public final void setPassword(String password) {
        this.password = password;
    }

    @Argument
    public final void setUrl(String url) {
        this.url = url;
    }

    @Option(name="u", longName="user", description="User name for user/password authentication")
    public final void setUser(String user) {
        this.user = user;
    }
}

