/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cyclopsgroup.jcli.AutoCompletable;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.MalformedArgException;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cli(name="option", description="Set options for command session")
public class OptionCommand
extends Command
implements AutoCompletable {
    private static final List<String> BOOLEAN_VALUES = Collections.unmodifiableList(Arrays.asList("true", "false"));
    private String abbreviated;
    private String verbose;

    private static Boolean toBoolean(String value) {
        if (value == null) {
            return null;
        }
        if (value.equalsIgnoreCase(Boolean.toString(true))) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase(Boolean.toString(false))) {
            return Boolean.FALSE;
        }
        throw new MalformedArgException("Boolean option value has to be yes|no, " + value + " is invalid");
    }

    @Override
    public List<String> doSuggestOption(String name) {
        return BOOLEAN_VALUES;
    }

    @Override
    public void execute() {
        Session session = this.getSession();
        Boolean v = OptionCommand.toBoolean(this.verbose);
        if (v != null) {
            session.setVerbose(v);
            session.msg("verbose option is turned " + (v != false ? "on" : "off"));
        } else {
            session.msg("no change for verbose, verbose = " + (session.isVerbose() ? "yes" : "no"));
        }
        Boolean a = OptionCommand.toBoolean(this.abbreviated);
        if (a != null) {
            session.setAbbreviated(a);
            session.msg("abbreviated option is turned " + (a != false ? "on" : "off"));
        } else {
            session.msg("no change for abbreviated, abbreviated = " + (session.isAbbreviated() ? "yes" : "no"));
        }
        session.ok();
    }

    @Option(name="a", longName="abbreviated", description="true|false")
    public final void setAbbreviated(String abbreviated) {
        this.abbreviated = abbreviated;
    }

    @Option(name="v", longName="verbose", description="true|false")
    public final void setVerbose(String verbose) {
        this.verbose = verbose;
    }
}

