/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.jdk5;

import java.io.IOException;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jmxterm.JavaProcess;
import org.cyclopsgroup.jmxterm.jdk5.ConnectorAddressLink;

class Jdk5JavaProcess
implements JavaProcess {
    private final int processId;
    private final ConnectorAddressLink connectorAddressLink;
    private final String command;
    private String url;

    Jdk5JavaProcess(int processId, String command, ConnectorAddressLink connectorAddressLink) {
        Validate.isTrue((processId > 0 ? 1 : 0) != 0, (String)("Invalid process ID " + processId));
        Validate.notNull((Object)command, (String)"Command line can't be NULL");
        Validate.notNull((Object)connectorAddressLink, (String)"connectorAddressLink can't be NULL");
        this.processId = processId;
        this.command = command;
        this.connectorAddressLink = connectorAddressLink;
    }

    public String getDisplayName() {
        return this.command;
    }

    public int getProcessId() {
        return this.processId;
    }

    public boolean isManageable() {
        return this.url != null;
    }

    public void startManagementAgent() throws IOException {
        if (this.url != null) {
            return;
        }
        this.url = this.connectorAddressLink.importFrom(this.processId);
    }

    public String toUrl() {
        return this.url;
    }
}

