/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cc;

import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jmxterm.Connection;

class ConnectionImpl
implements Connection {
    private final JMXConnector connector;
    private final JMXServiceURL url;

    ConnectionImpl(JMXConnector connector, JMXServiceURL url) {
        Validate.notNull((Object)connector, (String)"JMX connector can't be NULL");
        Validate.notNull((Object)url, (String)"JMX service URL can't be NULL");
        this.connector = connector;
        this.url = url;
    }

    void close() throws IOException {
        this.connector.close();
    }

    public final JMXConnector getConnector() {
        return this.connector;
    }

    public String getConnectorId() throws IOException {
        return this.connector.getConnectionId();
    }

    public MBeanServerConnection getServerConnection() throws IOException {
        return this.connector.getMBeanServerConnection();
    }

    public final JMXServiceURL getUrl() {
        return this.url;
    }
}

