/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.io.IOException;
import java.util.Map;
import javax.management.JMException;
import org.apache.commons.collections.ExtendedProperties;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.JavaProcessManager;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.io.ValueOutputFormat;
import org.cyclopsgroup.jmxterm.utils.ExtendedPropertiesUtils;

@Cli(name="about", description="Display about page")
public class AboutCommand
extends Command {
    private boolean showDescription;

    public void execute() throws IOException, JMException {
        Session session = this.getSession();
        ExtendedProperties props = ExtendedPropertiesUtils.loadFromOverlappingResources("META-INF/cyclopsgroup/jmxterm.properties", this.getClass().getClassLoader());
        ValueOutputFormat format = new ValueOutputFormat(2, this.showDescription, true);
        for (Object e : props.subset("jmxterm.about").entrySet()) {
            Map.Entry entry = (Map.Entry)e;
            format.printExpression(session.output, entry.getKey(), entry.getValue(), null);
        }
        for (Map.Entry entry : System.getProperties().entrySet()) {
            String keyName = entry.toString();
            if (!keyName.startsWith("java.")) continue;
            format.printExpression(session.output, keyName, entry.getValue(), null);
        }
        JavaProcessManager jpm = JavaProcessManager.getInstance();
        format.printExpression(session.output, "jpm.type", jpm.getClass().getName(), "Type of JavaProcessManager implementation");
        format.printExpression(session.output, "jpm.name", jpm.getName(), "Name of JavaProcessManager implementation");
        format.printExpression(session.output, "jpm.description", jpm.getDescription(), "Description of JavaProcessManager implementation");
    }

    @Option(name="s", longName="show", description="Show detail description")
    public final void setShowDescription(boolean showDescription) {
        this.showDescription = showDescription;
    }
}

