/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.io.RuntimeIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cli(name="domains", description="List all available domain names")
public class DomainsCommand
extends Command {
    static List<String> getCandidateDomains(Session session) {
        String[] domains;
        try {
            domains = session.getConnection().getServerConnection().getDomains();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Couldn't get candate domains", e);
        }
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(domains));
        Collections.sort(result);
        return result;
    }

    @Override
    public void execute() throws IOException {
        Session session = this.getSession();
        session.output.printMessage("following domains are available");
        for (String domain : DomainsCommand.getCandidateDomains(session)) {
            session.output.println(domain);
        }
    }
}

