/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jcli.AutoCompletable;
import org.cyclopsgroup.jcli.annotation.Argument;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.cmd.BeanCommand;
import org.cyclopsgroup.jmxterm.cmd.DomainsCommand;
import org.cyclopsgroup.jmxterm.io.ValueOutputFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cli(name="get", description="Get value of MBean attribute(s)", note="* stands for all attributes. eg. get Attribute1 Attribute2 or get *")
public class GetCommand
extends Command
implements AutoCompletable {
    private List<String> attributes = new ArrayList<String>();
    private String bean;
    private String domain;
    private boolean showDescription;
    private boolean showQuotationMarks;
    private boolean simpleFormat;

    private void displayAttributes() throws IOException, JMException {
        Session session = this.getSession();
        String beanName = BeanCommand.getBeanName(this.bean, this.domain, session);
        ObjectName name = new ObjectName(beanName);
        session.output.printMessage("mbean = " + beanName + ":");
        MBeanServerConnection con = session.getConnection().getServerConnection();
        MBeanAttributeInfo[] ais = con.getMBeanInfo(name).getAttributes();
        OrderedMap attributeNames = ListOrderedMap.decorate(new HashMap());
        if (this.attributes.contains("*")) {
            for (MBeanAttributeInfo ai : ais) {
                attributeNames.put(ai.getName(), ai);
            }
        } else {
            block1: for (String arg : this.attributes) {
                for (MBeanAttributeInfo ai : ais) {
                    if (!ai.getName().equals(arg)) continue;
                    attributeNames.put(arg, ai);
                    continue block1;
                }
            }
        }
        ValueOutputFormat format = new ValueOutputFormat(2, this.showDescription, this.showQuotationMarks);
        for (Map.Entry entry : attributeNames.entrySet()) {
            String attributeName = (String)entry.getKey();
            MBeanAttributeInfo i = (MBeanAttributeInfo)entry.getValue();
            if (i.isReadable()) {
                Object result = con.getAttribute(name, attributeName);
                if (this.simpleFormat) {
                    format.printValue(session.output, result);
                } else {
                    format.printExpression(session.output, attributeName, result, i.getDescription());
                }
                session.output.println("");
                continue;
            }
            session.output.printMessage(i.getName() + " is not readable");
        }
    }

    @Override
    public List<String> doSuggestArgument() throws IOException, JMException {
        if (this.getSession().getBean() != null) {
            MBeanServerConnection con = this.getSession().getConnection().getServerConnection();
            MBeanAttributeInfo[] ais = con.getMBeanInfo(new ObjectName(this.getSession().getBean())).getAttributes();
            ArrayList<String> results = new ArrayList<String>(ais.length);
            for (MBeanAttributeInfo ai : ais) {
                results.add(ai.getName());
            }
            return results;
        }
        return null;
    }

    @Override
    protected List<String> doSuggestOption(String optionName) throws JMException {
        if (optionName.equals("d")) {
            return DomainsCommand.getCandidateDomains(this.getSession());
        }
        if (optionName.equals("b")) {
            return BeanCommand.getCandidateBeanNames(this.getSession());
        }
        return null;
    }

    @Override
    public void execute() throws JMException, IOException {
        if (this.attributes.isEmpty()) {
            throw new IllegalArgumentException("Please specify at least one attribute");
        }
        this.displayAttributes();
    }

    @Argument(description="Name of attributes to select")
    public final void setAttributes(List<String> attributes) {
        Validate.notNull(attributes, (String)"Attributes can't be NULL");
        this.attributes = attributes;
    }

    @Option(name="b", longName="bean", description="MBean name where the attribute is. Optional if bean has been set")
    public final void setBean(String bean) {
        this.bean = bean;
    }

    @Option(name="d", longName="domain", description="Domain of bean, optional")
    public final void setDomain(String domain) {
        this.domain = domain;
    }

    @Option(name="i", longName="info", description="Show detail information of each attribute")
    public final void setShowDescription(boolean showDescription) {
        this.showDescription = showDescription;
    }

    @Option(name="q", longName="quots", description="Quotation marks around value")
    public final void setShowQuotationMarks(boolean noQuotationMarks) {
        this.showQuotationMarks = noQuotationMarks;
    }

    @Option(name="s", longName="simple", description="Print simple expression of value without full expression")
    public final void setSimpleFormat(boolean simpleFormat) {
        this.simpleFormat = simpleFormat;
    }
}

