/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import javax.management.JMException;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.JavaProcess;
import org.cyclopsgroup.jmxterm.JavaProcessManager;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.utils.SyntaxUtils;

@Cli(name="jvms", description="List all running local JVM processes")
public class JvmsCommand
extends Command {
    private boolean pidOnly;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException, JMException {
        List<JavaProcess> processList;
        Session session = this.getSession();
        PrintStream stdOut = System.out;
        System.setOut(SyntaxUtils.NULL_PRINT_STREAM);
        try {
            processList = JavaProcessManager.getInstance().list();
        }
        finally {
            System.setOut(stdOut);
        }
        for (JavaProcess p : processList) {
            if (this.pidOnly) {
                session.output.println(String.valueOf(p.getProcessId()));
                continue;
            }
            session.output.println(String.format("%-8d (%s) - %s", p.getProcessId(), p.isManageable() ? "m" : " ", p.getDisplayName()));
        }
    }

    @Option(name="p", longName="pidonly", description="Only print out PID")
    public final void setPidOnly(boolean pidOnly) {
        this.pidOnly = pidOnly;
    }
}

