/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.io;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.cyclopsgroup.jmxterm.io.CommandOutput;
import org.cyclopsgroup.jmxterm.io.VerboseCommandOutputConfig;
import org.cyclopsgroup.jmxterm.io.VerboseLevel;

public class VerboseCommandOutput
extends CommandOutput {
    private final VerboseCommandOutputConfig config;
    private final CommandOutput output;

    public VerboseCommandOutput(CommandOutput output, VerboseCommandOutputConfig config) {
        Validate.notNull((Object)output, (String)"The proxy'ed output can't be NULL");
        Validate.notNull((Object)config, (String)"Config can't be NULL");
        this.output = output;
        this.config = config;
    }

    public void close() {
        this.output.close();
    }

    public void print(String value) {
        this.output.print(value);
    }

    public void printError(Throwable e) {
        switch (this.config.getVerboseLevel()) {
            case VERBOSE: {
                this.output.printError(e);
                break;
            }
            case SILENT: {
                break;
            }
            default: {
                this.output.printMessage("#" + ExceptionUtils.getMessage((Throwable)e));
            }
        }
    }

    public void printMessage(String message) {
        if (this.config.getVerboseLevel() != VerboseLevel.SILENT) {
            this.output.printMessage("#" + message);
        }
    }
}

