/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm;

import java.io.IOException;
import java.util.List;
import javax.management.JMException;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cyclopsgroup.jcli.AutoCompletable;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jmxterm.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Command
implements AutoCompletable {
    private static final Log LOG = LogFactory.getLog(Command.class);
    private boolean help;
    private Session session;

    protected List<String> doSuggestArgument() throws IOException, JMException {
        return null;
    }

    protected List<String> doSuggestOption(String optionName) throws IOException, JMException {
        return null;
    }

    public abstract void execute() throws IOException, JMException;

    public final Session getSession() {
        return this.session;
    }

    public final boolean isHelp() {
        return this.help;
    }

    @Option(name="h", longName="help", description="Display usage")
    public final void setHelp(boolean help) {
        this.help = help;
    }

    public final void setSession(Session session) {
        Validate.notNull((Object)session, (String)"Session can't be NULL");
        this.session = session;
    }

    public final List<String> suggestArgument(String partialArg) {
        if (partialArg != null) {
            return null;
        }
        try {
            return this.doSuggestArgument();
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Couldn't suggest option", (Throwable)e);
            }
            return null;
        }
        catch (JMException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Couldn't suggest option", (Throwable)e);
            }
            return null;
        }
    }

    public final List<String> suggestOption(String name, String partialValue) {
        if (partialValue != null) {
            return null;
        }
        try {
            return this.doSuggestOption(name);
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Couldn't suggest option", (Throwable)e);
            }
            return null;
        }
        catch (JMException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Couldn't suggest option", (Throwable)e);
            }
            return null;
        }
    }
}

