/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm;

import java.io.IOException;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jmxterm.Connection;
import org.cyclopsgroup.jmxterm.JavaProcessManager;
import org.cyclopsgroup.jmxterm.io.CommandInput;
import org.cyclopsgroup.jmxterm.io.CommandOutput;
import org.cyclopsgroup.jmxterm.io.UnimplementedCommandInput;
import org.cyclopsgroup.jmxterm.io.VerboseCommandOutput;
import org.cyclopsgroup.jmxterm.io.VerboseCommandOutputConfig;
import org.cyclopsgroup.jmxterm.io.VerboseLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Session
implements VerboseCommandOutputConfig {
    private String bean;
    private boolean closed;
    private String domain;
    public final CommandInput input;
    public final CommandOutput output;
    public final JavaProcessManager processManager;
    private VerboseLevel verboseLevel = VerboseLevel.BRIEF;

    protected Session(CommandOutput output, CommandInput input, JavaProcessManager processManager) {
        Validate.notNull((Object)output, (String)"Output can't be NULL");
        Validate.notNull((Object)processManager, (String)"Process manager can't be NULL");
        this.output = new VerboseCommandOutput(output, this);
        this.input = input == null ? new UnimplementedCommandInput() : input;
        this.processManager = processManager;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    public abstract void connect(JMXServiceURL var1, Map<String, Object> var2) throws IOException;

    public abstract void disconnect() throws IOException;

    public final String getBean() {
        return this.bean;
    }

    public abstract Connection getConnection();

    public final String getDomain() {
        return this.domain;
    }

    @Override
    public final VerboseLevel getVerboseLevel() {
        return this.verboseLevel;
    }

    public final boolean isClosed() {
        return this.closed;
    }

    public abstract boolean isConnected();

    public final void setBean(String bean) {
        this.bean = bean;
    }

    public final void setDomain(String domain) {
        Validate.notNull((Object)domain, (String)"domain can't be NULL");
        this.domain = domain;
    }

    public final void setVerboseLevel(VerboseLevel verboseLevel) {
        Validate.notNull((Object)((Object)verboseLevel), (String)"Verbose level can't be NULL");
        this.verboseLevel = verboseLevel;
    }

    public void unsetDomain() {
        this.bean = null;
        this.domain = null;
    }
}

