/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.regex.Pattern;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.cyclopsgroup.jmxterm.JavaProcess;
import org.cyclopsgroup.jmxterm.JavaProcessManager;

public final class SyntaxUtils {
    public static final String NULL = "null";
    public static final PrintStream NULL_PRINT_STREAM = new PrintStream((OutputStream)new NullOutputStream(), true);
    private static final Pattern PATTERN_HOST_PORT = Pattern.compile("^(\\w|\\.|\\-)+\\:\\d+$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JMXServiceURL getUrl(String url, JavaProcessManager jpm) throws IOException {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException("Empty URL is not allowed");
        }
        if (NumberUtils.isDigits((String)url) && jpm != null) {
            Integer pid = Integer.parseInt(url);
            PrintStream stdOut = System.out;
            System.setOut(NULL_PRINT_STREAM);
            try {
                JavaProcess p = jpm.get(pid);
                if (p == null) {
                    throw new NullPointerException("No such PID " + pid);
                }
                if (!p.isManageable()) {
                    p.startManagementAgent();
                    if (!p.isManageable()) {
                        throw new IllegalStateException("Managed agent for PID " + pid + " couldn't start. PID " + pid + " is not manageable");
                    }
                }
                JMXServiceURL jMXServiceURL = new JMXServiceURL(p.toUrl());
                return jMXServiceURL;
            }
            finally {
                System.setOut(stdOut);
            }
        }
        if (PATTERN_HOST_PORT.matcher(url).find()) {
            return new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + url + "/jmxrmi");
        }
        return new JMXServiceURL(url);
    }

    public static boolean isNull(String s) {
        return StringUtils.equalsIgnoreCase((String)NULL, (String)s) || StringUtils.equals((String)"*", (String)s);
    }

    public static Object parse(String expression, String type) {
        Class c;
        if (StringUtils.isEmpty((String)expression) || SyntaxUtils.isNull(expression)) {
            return null;
        }
        try {
            c = ClassUtils.getClass((String)type);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Type " + type + " isn't valid", e);
        }
        return ConvertUtils.convert((String)expression, (Class)c);
    }

    private SyntaxUtils() {
    }
}

