/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cc;

import org.apache.commons.lang.SystemUtils;
import org.cyclopsgroup.jmxterm.JavaProcessManager;
import org.cyclopsgroup.jmxterm.jdk5.Jdk5JavaProcessManager;
import org.cyclopsgroup.jmxterm.jdk6.Jdk6JavaProcessManager;
import org.cyclopsgroup.jmxterm.pm.JConsoleClassLoaderFactory;
import org.cyclopsgroup.jmxterm.pm.UnsupportedJavaProcessManager;

public class JPMFactory {
    private final JavaProcessManager jpm;

    public JPMFactory() {
        JavaProcessManager j;
        if (!SystemUtils.isJavaVersionAtLeast((int)150)) {
            this.jpm = new UnsupportedJavaProcessManager("JDK version " + SystemUtils.JAVA_RUNTIME_VERSION + " doesn't support this command");
            return;
        }
        try {
            ClassLoader cl = JConsoleClassLoaderFactory.getClassLoader();
            j = SystemUtils.IS_JAVA_1_5 ? new Jdk5JavaProcessManager(cl) : new Jdk6JavaProcessManager(cl);
        }
        catch (ClassNotFoundException e) {
            j = new UnsupportedJavaProcessManager(e.getMessage() + ", operation on this JDK(" + SystemUtils.JAVA_RUNTIME_VERSION + ") isn't fully supported", e);
        }
        catch (Exception e) {
            j = new UnsupportedJavaProcessManager(e);
        }
        this.jpm = j;
    }

    final JavaProcessManager getProcessManager() {
        return this.jpm;
    }
}

