/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang.math.NumberUtils;
import org.cyclopsgroup.jcli.annotation.Argument;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Connection;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.SyntaxUtils;

@Cli(name="open", description="Open JMX session or display current connection", note="Without argument this command display current connection. URL can be a <PID>, <hostname>:<port> or full qualified JMX service URL. For example\n open localhost:9991,\n open jmx:service:...")
public class OpenCommand
extends Command {
    private String password;
    private String url;
    private String user;

    public void execute() throws IOException {
        HashMap<String, Object> env;
        Session session = this.getSession();
        if (this.url == null) {
            Connection con = session.getConnection();
            if (con == null) {
                session.output.printMessage("not connected");
                session.output.println("null");
            } else {
                session.output.println(String.format("%s,%s", con.getConnectorId(), con.getUrl()));
            }
            return;
        }
        if (this.user != null) {
            if (this.password == null) {
                this.password = session.input.readMaskedString("Credential password: ");
            }
            env = new HashMap<String, Object>(1);
            String[] credentials = new String[]{this.user, this.password};
            env.put("jmx.remote.credentials", credentials);
        } else {
            env = null;
        }
        try {
            session.connect(SyntaxUtils.getUrl(this.url, session.processManager), env);
            session.output.printMessage("Connection to " + this.url + " is opened");
        }
        catch (IOException e) {
            if (NumberUtils.isDigits((String)this.url)) {
                session.output.printMessage("Couldn't connect to PID " + this.url + ", it's likely that your version of JDK doesn't allow to connect to a process directly");
            }
            throw e;
        }
    }

    @Option(name="p", longName="password", description="Password for user/password authentication")
    public final void setPassword(String password) {
        this.password = password;
    }

    @Argument
    public final void setUrl(String url) {
        this.url = url;
    }

    @Option(name="u", longName="user", description="User name for user/password authentication")
    public final void setUser(String user) {
        this.user = user;
    }
}

