/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cyclopsgroup.jcli.AutoCompletable;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.MalformedArgException;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.io.VerboseLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cli(name="option", description="Set options for command session")
public class OptionCommand
extends Command
implements AutoCompletable {
    private static final List<String> VERBOSE_LEVEL_VALUES;
    private String verboseLevel;

    @Override
    public List<String> doSuggestOption(String name) {
        return VERBOSE_LEVEL_VALUES;
    }

    @Override
    public void execute() {
        Session session = this.getSession();
        if (this.verboseLevel == null) {
            session.output.printMessage("no change for verbose, verbose = " + (Object)((Object)session.getVerboseLevel()));
        } else {
            VerboseLevel v;
            try {
                v = VerboseLevel.valueOf(this.verboseLevel.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new MalformedArgException("Invalid verbose level value " + this.verboseLevel, (Throwable)e);
            }
            session.setVerboseLevel(v);
            session.output.printMessage("verbose option is turned to " + (Object)((Object)v));
        }
    }

    @Option(name="v", longName="verbose", description="Verbose level: SILENT|BRIEF|VERBOSE")
    public final void setVerboseLevel(String verbose) {
        this.verboseLevel = verbose;
    }

    static {
        ArrayList<String> verboseLevelValues = new ArrayList<String>();
        verboseLevelValues.addAll(VerboseLevel.STRING_NAMES);
        for (String v : VerboseLevel.STRING_NAMES) {
            verboseLevelValues.add(v.toLowerCase());
        }
        VERBOSE_LEVEL_VALUES = Collections.unmodifiableList(verboseLevelValues);
    }
}

