/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jcli.AutoCompletable;
import org.cyclopsgroup.jcli.annotation.Argument;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.SyntaxUtils;
import org.cyclopsgroup.jmxterm.cmd.BeanCommand;
import org.cyclopsgroup.jmxterm.io.ValueOutputFormat;
import org.cyclopsgroup.jmxterm.utils.ValueFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cli(name="run", description="Invoke an MBean operation", note="Syntax is \n run <operationName> [parameter1] [parameter2]")
public class RunCommand
extends Command
implements AutoCompletable {
    private String bean;
    private String domain;
    private boolean measure;
    private List<String> parameters = Collections.emptyList();
    private boolean showQuotationMarks;

    @Override
    public List<String> doSuggestArgument() throws IOException, JMException {
        Session session = this.getSession();
        if (this.getSession().getBean() != null) {
            MBeanInfo info = session.getConnection().getServerConnection().getMBeanInfo(new ObjectName(session.getBean()));
            MBeanOperationInfo[] operationInfos = info.getOperations();
            ArrayList<String> ops = new ArrayList<String>(operationInfos.length);
            for (MBeanOperationInfo op : operationInfos) {
                ops.add(op.getName());
            }
            return ops;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws MalformedObjectNameException, IOException, JMException {
        Object result;
        MBeanParameterInfo[] paramInfos;
        Session session = this.getSession();
        String beanName = BeanCommand.getBeanName(this.bean, this.domain, session);
        if (beanName == null) {
            throw new IllegalArgumentException("Please specify MBean to invoke either using -b option or bean command");
        }
        Validate.isTrue((this.parameters.size() > 0 ? 1 : 0) != 0, (String)"At least one parameter is needed");
        String operationName = this.parameters.get(0);
        ObjectName name = new ObjectName(beanName);
        MBeanServerConnection con = session.getConnection().getServerConnection();
        MBeanInfo beanInfo = con.getMBeanInfo(name);
        MBeanOperationInfo operationInfo = null;
        for (MBeanOperationInfo info : beanInfo.getOperations()) {
            if (!operationName.equals(info.getName()) || info.getSignature().length != this.parameters.size() - 1) continue;
            operationInfo = info;
            break;
        }
        if (operationInfo == null) {
            throw new IllegalArgumentException("Operation " + operationName + " with " + (this.parameters.size() - 1) + " parameters doesn't exist in bean " + beanName);
        }
        Object[] params = new Object[this.parameters.size() - 1];
        Validate.isTrue((params.length == (paramInfos = operationInfo.getSignature()).length ? 1 : 0) != 0, (String)String.format("%d parameters are expected but %d are provided", paramInfos.length, params.length));
        String[] signatures = new String[paramInfos.length];
        for (int i = 0; i < paramInfos.length; ++i) {
            MBeanParameterInfo paramInfo = paramInfos[i];
            Object paramValue = SyntaxUtils.parse(this.parameters.get(i + 1), paramInfo.getType());
            if (paramValue != null && paramValue instanceof String) {
                paramValue = ValueFormat.parseValue((String)paramValue);
            }
            params[i] = paramValue;
            signatures[i] = paramInfo.getType();
        }
        session.output.printMessage(String.format("calling operation %s of mbean %s", operationName, beanName));
        if (this.measure) {
            long start = System.currentTimeMillis();
            try {
                result = con.invoke(name, operationName, params, signatures);
            }
            finally {
                long latency = System.currentTimeMillis() - start;
                session.output.printMessage(latency + "ms is taken by invocation");
            }
        } else {
            result = con.invoke(name, operationName, params, signatures);
        }
        session.output.printMessage("operation returns: ");
        new ValueOutputFormat(2, false, this.showQuotationMarks).printValue(session.output, result);
        session.output.println("");
    }

    @Option(name="b", longName="bean", description="MBean to invoke")
    public final void setBean(String bean) {
        this.bean = bean;
    }

    @Option(name="d", longName="domain", description="Domain of MBean to invoke")
    public final void setDomain(String domain) {
        this.domain = domain;
    }

    @Option(name="m", longName="measure", description="Measure the time spent on the invocation of operation")
    public final void setMeasure(boolean measure) {
        this.measure = measure;
    }

    @Argument(description="The first parameter is operation name, which is followed by list of arguments")
    public final void setParameters(List<String> parameters) {
        Validate.notNull(parameters, (String)"Parameters can't be NULL");
        this.parameters = parameters;
    }

    @Option(name="q", longName="quots", description="Flag for quotation marks")
    public final void setShowQuotationMarks(boolean showQuotationMarks) {
        this.showQuotationMarks = showQuotationMarks;
    }
}

