/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jcli.annotation.Argument;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.SyntaxUtils;
import org.cyclopsgroup.jmxterm.cmd.BeanCommand;
import org.cyclopsgroup.jmxterm.cmd.DomainsCommand;
import org.cyclopsgroup.jmxterm.utils.ValueFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cli(name="set", description="Set value of an MBean attribute")
public class SetCommand
extends Command {
    private List<String> arguments = Collections.emptyList();
    private String bean;
    private String domain;

    @Override
    protected List<String> doSuggestArgument() throws IOException, JMException {
        Session session = this.getSession();
        if (session.getBean() != null) {
            MBeanServerConnection conn = this.getSession().getConnection().getServerConnection();
            MBeanInfo info = conn.getMBeanInfo(new ObjectName(session.getBean()));
            MBeanAttributeInfo[] attrs = info.getAttributes();
            ArrayList<String> attributeNames = new ArrayList<String>(attrs.length);
            for (MBeanAttributeInfo attr : attrs) {
                attributeNames.add(attr.getName());
            }
            return attributeNames;
        }
        return null;
    }

    @Override
    protected List<String> doSuggestOption(String optionName) throws JMException {
        if (optionName.equals("d")) {
            return DomainsCommand.getCandidateDomains(this.getSession());
        }
        if (optionName.equals("b")) {
            return BeanCommand.getCandidateBeanNames(this.getSession());
        }
        return null;
    }

    @Override
    public void execute() throws JMException, IOException {
        Validate.isTrue((this.arguments.size() >= 2 ? 1 : 0) != 0, (String)"At least two arguments are required");
        Session session = this.getSession();
        String attributeName = this.arguments.get(0);
        String beanName = BeanCommand.getBeanName(this.bean, this.domain, session);
        ObjectName name = new ObjectName(beanName);
        MBeanServerConnection con = session.getConnection().getServerConnection();
        MBeanInfo beanInfo = con.getMBeanInfo(new ObjectName(beanName));
        MBeanAttributeInfo attributeInfo = null;
        for (MBeanAttributeInfo i : beanInfo.getAttributes()) {
            if (!i.getName().equals(attributeName)) continue;
            attributeInfo = i;
            break;
        }
        if (attributeInfo == null) {
            throw new IllegalArgumentException("Attribute " + attributeName + " is not sepcified");
        }
        if (!attributeInfo.isWritable()) {
            throw new IllegalArgumentException("Attribute " + attributeName + " is not writable");
        }
        String inputValue = this.arguments.get(1);
        Object value = SyntaxUtils.parse(inputValue, attributeInfo.getType());
        if (value != null && value instanceof String) {
            value = ValueFormat.parseValue((String)value);
        }
        con.setAttribute(name, new Attribute(attributeName, value));
        session.output.printMessage("Value of attribute " + attributeName + " is set to " + inputValue);
    }

    @Argument(description="name, value, value2...")
    public final void setArguments(List<String> arguments) {
        Validate.notNull(arguments, (String)"Arguments can't be NULL");
        this.arguments = arguments;
    }

    @Option(name="b", longName="bean", description="MBean name where the attribute is. Optional if bean has been set")
    public final void setBean(String bean) {
        this.bean = bean;
    }

    @Option(name="d", longName="domain", description="Domain under which the bean is")
    public final void setDomain(String domain) {
        this.domain = domain;
    }
}

