/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jmxterm.io.CommandOutput;
import org.cyclopsgroup.jmxterm.io.WriterCommandOutput;

public class FileCommandOutput
extends CommandOutput {
    private final PrintWriter fileWriter;
    private final WriterCommandOutput output;

    public FileCommandOutput(File file) throws IOException {
        Validate.notNull((Object)file, (String)"File can't be NULL");
        File af = file.getAbsoluteFile();
        if (!af.getParentFile().isDirectory() && !af.getParentFile().mkdirs()) {
            throw new IOException("Couldn't make directory " + af.getParentFile());
        }
        this.fileWriter = new PrintWriter(new FileWriter(af));
        this.output = new WriterCommandOutput(this.fileWriter, new PrintWriter(System.err, true));
    }

    public void close() {
        this.fileWriter.flush();
        this.fileWriter.close();
    }

    public void print(String value) {
        this.output.print(value);
    }

    public void printError(Throwable e) {
        this.output.printError(e);
    }

    public void printMessage(String message) {
        this.output.printMessage(message);
    }
}

