/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.jdk5;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cyclopsgroup.jmxterm.JavaProcess;
import org.cyclopsgroup.jmxterm.JavaProcessManager;
import org.cyclopsgroup.jmxterm.jdk5.ConnectorAddressLink;
import org.cyclopsgroup.jmxterm.jdk5.Jdk5JavaProcess;
import org.cyclopsgroup.jmxterm.jdk5.MonitoredHost;
import org.cyclopsgroup.jmxterm.utils.WeakCastUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jdk5JavaProcessManager
extends JavaProcessManager {
    private static final String CLASS_HOST_IDENTIFIER = "sun.jvmstat.monitor.HostIdentifier";
    private static final String CLASS_MONITORED_VM = "sun.jvmstat.monitor.MonitoredVm";
    private static final String CLASS_MONITORED_VM_UTIL = "sun.jvmstat.monitor.MonitoredVmUtil";
    private static final String CLASS_VM_IDENTIFIER = "sun.jvmstat.monitor.VmIdentifier";
    private static final Log LOG = LogFactory.getLog(Jdk5JavaProcessManager.class);
    private final ConnectorAddressLink connectorAddressLink;
    private final Method getMonitoredVm;
    private final MonitoredHost localhost;
    private final Object localhostDelegate;
    private final Class<?> monitoredVmType;
    private final Method toCommandLine;
    private final Constructor<?> vmIdentifierConstructor;

    public Jdk5JavaProcessManager(ClassLoader classLoader) throws Exception {
        Validate.notNull((Object)classLoader, (String)"ClassLoader can't be NULL");
        this.connectorAddressLink = WeakCastUtils.staticCast(classLoader.loadClass("sun.management.ConnectorAddressLink"), ConnectorAddressLink.class);
        Class<?> hic = classLoader.loadClass(CLASS_HOST_IDENTIFIER);
        Object hi = hic.getConstructor(String.class).newInstance(new Object[]{null});
        Class<?> mhc = classLoader.loadClass("sun.jvmstat.monitor.MonitoredHost");
        Method getInstance = mhc.getMethod("getMonitoredHost", hic);
        this.localhostDelegate = getInstance.invoke(null, hi);
        this.localhost = WeakCastUtils.cast(this.localhostDelegate, MonitoredHost.class);
        Class<?> monitoredVmUtilClass = classLoader.loadClass(CLASS_MONITORED_VM_UTIL);
        this.monitoredVmType = classLoader.loadClass(CLASS_MONITORED_VM);
        this.toCommandLine = monitoredVmUtilClass.getMethod("commandLine", this.monitoredVmType);
        Class<?> vmIdentifierType = classLoader.loadClass(CLASS_VM_IDENTIFIER);
        this.vmIdentifierConstructor = vmIdentifierType.getConstructor(String.class);
        this.getMonitoredVm = mhc.getMethod("getMonitoredVm", vmIdentifierType);
    }

    @Override
    public JavaProcess get(int pid) {
        Validate.isTrue((pid > 0 ? 1 : 0) != 0, (String)("PID " + pid + " isn't valid"));
        try {
            Object vmid = this.vmIdentifierConstructor.newInstance(String.valueOf(pid));
            Object vm = this.getMonitoredVm.invoke(this.localhostDelegate, vmid);
            String cmd = (String)this.toCommandLine.invoke(null, vm);
            return new Jdk5JavaProcess(pid, cmd, this.connectorAddressLink);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Couldn't get infomrmation about PID " + pid, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Couldn't get infomrmation about PID " + pid, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Couldn't get infomrmation about PID " + pid, e);
        }
    }

    @Override
    public List<JavaProcess> list() {
        Set<Integer> pids = this.localhost.activeVms();
        ArrayList<JavaProcess> result = new ArrayList<JavaProcess>(pids.size());
        for (int pid : pids) {
            try {
                result.add(this.get(pid));
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Couldn't get PID" + pid), (Throwable)e);
            }
        }
        return result;
    }
}

