/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.pm;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.lang.SystemUtils;

public class JConsoleClassLoaderFactory {
    private JConsoleClassLoaderFactory() {
    }

    public static ClassLoader getClassLoader() {
        File jconsoleJar;
        File toolsJar;
        File javaHome = new File(SystemUtils.JAVA_HOME).getAbsoluteFile().getParentFile();
        if (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_MAC_OSX) {
            toolsJar = new File(javaHome, "Classes/classes.jar");
            jconsoleJar = new File(javaHome, "Classes/jconsole.jar");
        } else {
            toolsJar = new File(javaHome, "lib/tools.jar");
            jconsoleJar = new File(javaHome, "lib/jconsole.jar");
        }
        if (!toolsJar.isFile()) {
            throw new RuntimeException("Operation requires JDK instead of JRE");
        }
        if (!jconsoleJar.isFile()) {
            throw new RuntimeException(jconsoleJar + " file is not found");
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                try {
                    return new URLClassLoader(new URL[]{toolsJar.toURI().toURL(), jconsoleJar.toURI().toURL()}, String.class.getClassLoader());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Couddn't convert files to URLs " + toolsJar + ", " + jconsoleJar + ": " + e.getMessage(), e);
                }
            }
        });
    }
}

