/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.conversion;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.cyclopsgroup.caff.conversion.CharArrayConverter;
import org.cyclopsgroup.caff.conversion.CharSequenceConverter;
import org.cyclopsgroup.caff.conversion.Converter;
import org.cyclopsgroup.caff.conversion.EnumConverter;
import org.cyclopsgroup.caff.conversion.NullFriendlyConverter;
import org.cyclopsgroup.caff.conversion.SimpleReflectiveConverter;
import org.cyclopsgroup.caff.conversion.StringConverter;

public class SimpleConverter<T>
implements Converter<T> {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TYPES;
    private final Converter<T> proxy;

    @Override
    public T fromCharacters(CharSequence text) {
        return this.proxy.fromCharacters(text);
    }

    @Override
    public CharSequence toCharacters(T value) {
        return this.proxy.toCharacters(value);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SimpleConverter(Class<T> type) {
        void var2_8;
        if (type == null) {
            throw new NullPointerException("Type can't be NULL");
        }
        if (type == String.class) {
            StringConverter stringConverter = new StringConverter();
        } else if (type == CharSequence.class) {
            CharSequenceConverter charSequenceConverter = new CharSequenceConverter();
        } else if (type == char[].class) {
            CharArrayConverter charArrayConverter = new CharArrayConverter();
        } else if (type.isPrimitive()) {
            if (!PRIMITIVE_TYPES.containsKey(type)) throw new IllegalArgumentException("Type " + type + " is not supported by " + this.getClass());
            SimpleReflectiveConverter simpleReflectiveConverter = new SimpleReflectiveConverter(PRIMITIVE_TYPES.get(type));
        } else if (type.isEnum()) {
            EnumConverter<T> enumConverter = new EnumConverter<T>(type);
        } else {
            SimpleReflectiveConverter<T> simpleReflectiveConverter = new SimpleReflectiveConverter<T>(type);
        }
        this.proxy = new NullFriendlyConverter(var2_8);
    }

    static {
        HashMap<Class<Comparable<Boolean>>, Class> primitiveTypes = new HashMap<Class<Comparable<Boolean>>, Class>();
        primitiveTypes.put(Boolean.TYPE, Boolean.class);
        primitiveTypes.put(Short.TYPE, Short.class);
        primitiveTypes.put(Integer.TYPE, Integer.class);
        primitiveTypes.put(Long.TYPE, Long.class);
        primitiveTypes.put(Float.TYPE, Float.class);
        primitiveTypes.put(Double.TYPE, Double.class);
        PRIMITIVE_TYPES = Collections.unmodifiableMap(primitiveTypes);
    }
}

