/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jcli;

import java.util.List;
import org.cyclopsgroup.jcli.spi.CommandLine;
import org.cyclopsgroup.jcli.spi.CommandLineBuilder;
import org.cyclopsgroup.jcli.spi.CommandLineParser;
import org.cyclopsgroup.jcli.spi.Option;
import org.cyclopsgroup.jcli.spi.ParsingContext;

public class GnuParser
implements CommandLineParser {
    @Override
    public CommandLine parse(List<String> arguments, ParsingContext context) {
        CommandLineBuilder builder = new CommandLineBuilder();
        boolean expectingOptionValue = false;
        String optionName = null;
        boolean shortOption = false;
        for (String arg : arguments) {
            Option opt;
            if (expectingOptionValue) {
                if (shortOption) {
                    builder.withShortOption(optionName, arg);
                } else {
                    builder.withLongOption(optionName, arg);
                }
                expectingOptionValue = false;
                continue;
            }
            if (arg.startsWith("--")) {
                optionName = arg.substring(2);
                opt = context.optionWithLongName(optionName);
                if (opt == null) {
                    builder.withArgument(arg);
                    continue;
                }
                if (opt.isFlag()) {
                    builder.withLongFlag(optionName);
                    continue;
                }
                expectingOptionValue = true;
                shortOption = false;
                continue;
            }
            if (arg.startsWith("-")) {
                optionName = arg.substring(1);
                opt = context.optionWithShortName(optionName);
                if (opt == null) {
                    builder.withArgument(arg);
                    continue;
                }
                if (opt.isFlag()) {
                    builder.withShortFlag(optionName);
                    continue;
                }
                expectingOptionValue = true;
                shortOption = true;
                continue;
            }
            builder.withArgument(arg);
        }
        return builder.toCommandLine();
    }
}

