/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jcli.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.cyclopsgroup.caff.conversion.AnnotatedConverter;
import org.cyclopsgroup.caff.ref.ValueReference;
import org.cyclopsgroup.jcli.annotation.Argument;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.MultiValue;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jcli.impl.AnnotationArgument;
import org.cyclopsgroup.jcli.impl.AnnotationCli;
import org.cyclopsgroup.jcli.impl.AnnotationOption;
import org.cyclopsgroup.jcli.impl.AnnotationParsingContext;
import org.cyclopsgroup.jcli.impl.MultiValueReference;
import org.cyclopsgroup.jcli.impl.Reference;
import org.cyclopsgroup.jcli.impl.SingleValueReference;

class ParsingContextBuilder<T> {
    private final Class<T> beanType;

    private static <B, P> Reference<B> createReference(Class<B> beanType, ValueReference<B> reference, String longName) {
        Class<?> valueType = reference.getType();
        MultiValue multiValue = reference.getAnnotation(MultiValue.class);
        if (multiValue != null) {
            valueType = multiValue.valueType();
        }
        AnnotatedConverter converter = new AnnotatedConverter(valueType, reference.getAnontatedElements());
        if (multiValue != null) {
            return new MultiValueReference<B>(beanType, converter, reference, longName, multiValue.listType());
        }
        return new SingleValueReference<B>(beanType, converter, reference, longName);
    }

    @Nullable
    private static <A extends Annotation> A getAnnotation(PropertyDescriptor descriptor, Class<A> type) {
        A a = null;
        if (descriptor.getWriteMethod() != null) {
            a = descriptor.getWriteMethod().getAnnotation(type);
        }
        if (a == null && descriptor.getReadMethod() != null) {
            a = descriptor.getReadMethod().getAnnotation(type);
        }
        return a;
    }

    private static <T> List<ValueReference<T>> referenceOfDescriptors(Class<T> beanType) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(beanType);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Bean " + beanType + " is not correctly defined", e);
        }
        return Arrays.asList(beanInfo.getPropertyDescriptors()).stream().map(d -> ValueReference.instanceOf(d)).collect(Collectors.toList());
    }

    private static <T> ImmutableList<ValueReference<T>> referenceOfFields(Class<T> beanType) {
        HashMap refMap = new HashMap();
        FluentIterable.from(beanType.getFields()).append((Field[])beanType.getDeclaredFields()).toList().stream().map(f -> ValueReference.instanceOf(f)).forEach(f -> refMap.put(f.getName(), f));
        return ImmutableList.copyOf(refMap.values());
    }

    ParsingContextBuilder(Class<? extends T> beanType) {
        this.beanType = beanType;
    }

    AnnotationParsingContext<T> build() {
        ArrayList<AnnotationOption> options = new ArrayList<AnnotationOption>();
        HashMap references = new HashMap();
        Argument argument = null;
        ImmutableList<ValueReference<T>> writableReferences = FluentIterable.from(ParsingContextBuilder.referenceOfDescriptors(this.beanType)).append((Iterable<ValueReference<T>>)ParsingContextBuilder.referenceOfFields(this.beanType)).filter(r -> r.isWritable()).toList();
        for (ValueReference valueReference : writableReferences) {
            Option option = valueReference.getAnnotation(Option.class);
            if (option != null) {
                boolean flag = valueReference.getType() == Boolean.TYPE || valueReference.getType() == Boolean.class;
                boolean multiValue = valueReference.getAnnotation(MultiValue.class) != null;
                options.add(new AnnotationOption(option, flag, multiValue));
                references.put(option.name(), ParsingContextBuilder.createReference(this.beanType, valueReference, option.longName()));
                continue;
            }
            Argument arg = valueReference.getAnnotation(Argument.class);
            if (arg == null) continue;
            argument = arg;
            references.put("----arguments----", ParsingContextBuilder.createReference(this.beanType, valueReference, "----arguments----"));
        }
        return new AnnotationParsingContext(references, options, new AnnotationCli(this.beanType.getAnnotation(Cli.class)), argument == null ? null : new AnnotationArgument(argument));
    }
}

