/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.pm;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;

public class JConsoleClassLoaderFactory {
    private JConsoleClassLoaderFactory() {
    }

    public static ClassLoader getClassLoader() {
        File jconsoleJar;
        File toolsJar;
        if (JConsoleClassLoaderFactory.isJava9Plus()) {
            return JConsoleClassLoaderFactory.class.getClassLoader();
        }
        File javaHome = new File(SystemUtils.JAVA_HOME).getAbsoluteFile().getParentFile();
        if (JConsoleClassLoaderFactory.isBeforeJava7() && JConsoleClassLoaderFactory.isMacOs()) {
            toolsJar = new File(javaHome, "Classes/classes.jar");
            jconsoleJar = new File(javaHome, "Classes/jconsole.jar");
        } else {
            toolsJar = new File(javaHome, "lib/tools.jar");
            jconsoleJar = new File(javaHome, "lib/jconsole.jar");
        }
        if (!toolsJar.isFile()) {
            throw new RuntimeException("Operation requires JDK instead of JRE");
        }
        if (!jconsoleJar.isFile()) {
            throw new RuntimeException(jconsoleJar + " file is not found");
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                try {
                    return new URLClassLoader(new URL[]{toolsJar.toURI().toURL(), jconsoleJar.toURI().toURL()}, String.class.getClassLoader());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Couddn't convert files to URLs " + toolsJar + ", " + jconsoleJar + ": " + e.getMessage(), e);
                }
            }
        });
    }

    private static boolean isJava9Plus() {
        return SystemUtils.isJavaVersionAtLeast(JavaVersion.JAVA_9);
    }

    private static boolean isBeforeJava7() {
        return SystemUtils.IS_JAVA_1_5 || SystemUtils.IS_JAVA_1_6;
    }

    private static boolean isMacOs() {
        return SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_MAC_OSX;
    }
}

