/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.conversion;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.cyclopsgroup.caff.conversion.ConversionFailedException;
import org.cyclopsgroup.caff.conversion.Converter;
import org.cyclopsgroup.caff.conversion.ConverterFactory;
import org.cyclopsgroup.caff.conversion.DateField;

public class DateConverterFactory
implements ConverterFactory<Date> {
    @Override
    public Converter<Date> getConverterFor(Class<Date> valueType, Object hint) {
        String format = ((DateField)hint).format();
        return new DateConverter(format);
    }

    private class DateConverter
    implements Converter<Date> {
        private final SimpleDateFormat formatter;
        private final String format;

        private DateConverter(String format) {
            this.formatter = new SimpleDateFormat(format);
            this.format = format;
        }

        @Override
        public Date fromCharacters(CharSequence text) {
            try {
                return this.formatter.parse(text.toString());
            }
            catch (ParseException e) {
                throw new ConversionFailedException("Can't parse " + text + " as a date in " + this.format, e);
            }
        }

        @Override
        public CharSequence toCharacters(Date value) {
            return this.formatter.format(value);
        }
    }
}

