/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.dp.wiki;

import java.io.PrintWriter;
import org.apache.commons.lang3.StringUtils;
import org.cyclopsgroup.caff.dp.Instrument;
import org.cyclopsgroup.caff.dp.wiki.PreservedInstrument;

public class ExternalLinkInstrument
extends Instrument {
    @Override
    public int searchToOpen(String segment, Instrument parent) {
        if (parent != null && parent instanceof PreservedInstrument) {
            return -1;
        }
        return segment.indexOf(91);
    }

    @Override
    public int open(String segment, PrintWriter out) {
        String text;
        String href;
        int end = segment.indexOf(93);
        String content = segment.substring(1, end);
        String[] parts = StringUtils.split(content, '|');
        if (parts.length == 1) {
            href = content;
            text = content;
        } else {
            href = parts[0];
            text = parts[1];
        }
        this.printLink(href, text, out);
        return end;
    }

    private void printLink(String href, String text, PrintWriter out) {
        if (text == null) {
            text = "link";
        }
        out.write(" <a href=\"" + href + "\">" + text + "</a> ");
    }

    @Override
    public int searchToClose(String segment) {
        return segment.indexOf(93);
    }

    @Override
    public int close(String segment, PrintWriter out) {
        return 1;
    }
}

