/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.ref;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.cyclopsgroup.caff.ref.AccessFailureException;
import org.cyclopsgroup.caff.ref.FieldValueReference;
import org.cyclopsgroup.caff.ref.PropertyValueReference;

public abstract class ValueReference<T> {
    @Nullable
    private static Method findMethod(Class<?> type, String methodName, Class<?> ... parameterTypes) throws SecurityException {
        try {
            return type.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return type.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
    }

    public static <T> ValueReference<T> forProperty(String propertyName, Class<T> type, Class<?> propertyType) {
        Preconditions.checkArgument(propertyName != null && !propertyName.isEmpty(), "Invalid property name " + propertyName);
        Preconditions.checkNotNull(type, "Bean type can't be null.");
        String name = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        Method getter = ValueReference.findMethod(type, "get" + name, new Class[0]);
        if (getter != null) {
            Preconditions.checkArgument(propertyType.isAssignableFrom(getter.getReturnType()), "Property type is %s while getter returns %s.", propertyType, getter.getReturnType());
        }
        Method setter = ValueReference.findMethod(type, "set" + name, propertyType);
        return new PropertyValueReference(propertyName, propertyType, getter, setter);
    }

    public static <T> ValueReference<T> instanceOf(Field field) {
        return new FieldValueReference(field);
    }

    public static <T> ValueReference<T> instanceOf(PropertyDescriptor prop) {
        return new PropertyValueReference(prop);
    }

    @Nullable
    public abstract <A extends Annotation> A getAnnotation(Class<A> var1);

    public abstract ImmutableList<AnnotatedElement> getAnontatedElements();

    public abstract String getName();

    public abstract Class<?> getType();

    public abstract boolean isReadable();

    public abstract boolean isWritable();

    public abstract Object readValue(T var1) throws AccessFailureException;

    public abstract void writeValue(Object var1, T var2) throws AccessFailureException;
}

