/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jcli.spi;

import java.util.Collection;
import org.cyclopsgroup.jcli.spi.CommandLine;

public final class CommandLineBuilder {
    private static final String FLAG_VALUE = Boolean.TRUE.toString();
    private final CommandLine cl = new CommandLine();

    public CommandLine toCommandLine() {
        return this.cl;
    }

    public CommandLineBuilder withArgument(String argument) {
        this.cl.addArgument(argument);
        return this;
    }

    public CommandLineBuilder withArguments(Collection<String> arguments) {
        for (String arg : arguments) {
            this.withArgument(arg);
        }
        return this;
    }

    public CommandLineBuilder withLongFlag(String name) {
        this.withLongOption(name, FLAG_VALUE);
        return this;
    }

    public CommandLineBuilder withLongOption(String name, String value) {
        this.cl.addOptionValue(name, value, false);
        return this;
    }

    public CommandLineBuilder withShortFlag(String name) {
        this.withShortOption(name, FLAG_VALUE);
        return this;
    }

    public CommandLineBuilder withShortOption(String name, String value) {
        this.cl.addOptionValue(name, value, true);
        return this;
    }
}

