/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cc;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.cyclopsgroup.jcli.ArgumentProcessor;
import org.cyclopsgroup.jcli.annotation.Argument;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.MultiValue;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.cc.CommandCenter;
import org.cyclopsgroup.jmxterm.io.RuntimeIOException;

@Cli(name="help", description="Display available commands or usage of a command", note="Run \"help [command1] [command2] ...\" to display usage or certain command(s). Help without argument shows list of available commands")
public class HelpCommand
extends Command {
    private List<String> argNames = Collections.emptyList();
    private CommandCenter commandCenter = null;

    @Override
    public void execute() {
        Validate.notNull(this.commandCenter, "Command center hasn't been set yet", new Object[0]);
        if (this.argNames.isEmpty()) {
            ArrayList<String> commandNames = new ArrayList<String>(this.commandCenter.getCommandNames());
            Collections.sort(commandNames);
            this.getSession().output.printMessage("following commands are available to use:");
            for (String commandName : commandNames) {
                Class<? extends Command> commandType = this.commandCenter.getCommandType(commandName);
                org.cyclopsgroup.jcli.spi.Cli cli = ArgumentProcessor.forType(commandType).createParsingContext().cli();
                this.getSession().output.println(String.format("%-8s - %s", commandName, cli.getDescription()));
            }
        } else {
            for (String argName : this.argNames) {
                Class<? extends Command> commandType = this.commandCenter.getCommandType(argName);
                if (commandType == null) {
                    throw new IllegalArgumentException("Command " + argName + " is not found");
                }
                ArgumentProcessor<? extends Command> ap = ArgumentProcessor.forType(commandType);
                try {
                    ap.printHelp(new PrintWriter(System.out, true));
                }
                catch (IOException e) {
                    throw new RuntimeIOException("Can't print help message", e);
                }
            }
        }
    }

    @MultiValue(listType=ArrayList.class)
    @Argument
    public final void setArgNames(List<String> argNames) {
        Validate.notNull(argNames, "argNames can't be NULL", new Object[0]);
        this.argNames = argNames;
    }

    final void setCommandCenter(CommandCenter commandCenter) {
        Validate.notNull(commandCenter, "commandCenter can't be NULL", new Object[0]);
        this.commandCenter = commandCenter;
    }
}

