/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.management.JMException;
import org.apache.commons.configuration2.Configuration;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.io.ValueOutputFormat;
import org.cyclopsgroup.jmxterm.utils.ConfigurationUtils;

@Cli(name="about", description="Display about page")
public class AboutCommand
extends Command {
    private boolean showDescription;

    @Override
    public void execute() throws IOException, JMException {
        Session session = this.getSession();
        Configuration props = ConfigurationUtils.loadFromOverlappingResources("META-INF/cyclopsgroup/jmxterm.properties", this.getClass().getClassLoader());
        ValueOutputFormat format = new ValueOutputFormat(2, this.showDescription, true);
        Configuration subset = props.subset("jmxterm.about");
        Iterator<String> iterator = subset.getKeys();
        while (iterator.hasNext()) {
            String key = iterator.next();
            format.printExpression(session.output, key, subset.getProperty(key), null);
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String keyName = entry.toString();
            if (!keyName.startsWith("java.")) continue;
            format.printExpression(session.output, keyName, entry.getValue(), null);
        }
    }

    @Option(name="s", longName="show", description="Show detail description")
    public final void setShowDescription(boolean showDescription) {
        this.showDescription = showDescription;
    }
}

