/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cc;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.CommandFactory;
import org.cyclopsgroup.jmxterm.cc.HelpCommand;
import org.cyclopsgroup.jmxterm.cc.TypeMapCommandFactory;
import org.cyclopsgroup.jmxterm.utils.ConfigurationUtils;

class PredefinedCommandFactory
implements CommandFactory {
    private final CommandFactory delegate;

    PredefinedCommandFactory() throws IOException {
        this("META-INF/cyclopsgroup/jmxterm.properties");
    }

    public PredefinedCommandFactory(String configPath) throws IOException {
        Validate.notNull((Object)configPath, (String)"configPath can't be NULL", (Object[])new Object[0]);
        ClassLoader classLoader = this.getClass().getClassLoader();
        Configuration props = ConfigurationUtils.loadFromOverlappingResources(configPath, classLoader);
        if (props == null) {
            throw new FileNotFoundException("Couldn't load configuration from " + configPath + ", classpath has problem");
        }
        if ((props = props.subset("jmxterm.commands")) == null) {
            throw new IOException("Expected configuration doesn't appear in " + configPath);
        }
        HashMap<String, Class<? extends Command>> commands = new HashMap<String, Class<? extends Command>>();
        for (String name : props.getStringArray("name")) {
            Class<?> commandType;
            String type = props.getString(name + ".type");
            try {
                commandType = classLoader.loadClass(type);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Couldn't load type " + type, e);
            }
            commands.put(name, commandType);
            Object[] aliases = props.getStringArray(name + ".alias");
            if (ArrayUtils.isEmpty((Object[])aliases)) continue;
            for (Object alias : aliases) {
                commands.put((String)alias, commandType);
            }
        }
        commands.put("help", HelpCommand.class);
        this.delegate = new TypeMapCommandFactory(commands);
    }

    @Override
    public Command createCommand(String commandName) {
        return this.delegate.createCommand(commandName);
    }

    @Override
    public Map<String, Class<? extends Command>> getCommandTypes() {
        return this.delegate.getCommandTypes();
    }
}

