/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cc;

import java.io.IOException;
import java.util.Map;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.lang3.Validate;
import org.cyclopsgroup.jmxterm.Connection;
import org.cyclopsgroup.jmxterm.JavaProcessManager;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.cc.ConnectionImpl;
import org.cyclopsgroup.jmxterm.io.CommandInput;
import org.cyclopsgroup.jmxterm.io.CommandOutput;

class SessionImpl
extends Session {
    private ConnectionImpl connection;

    SessionImpl(CommandOutput output, CommandInput input, JavaProcessManager jpm) {
        super(output, input, jpm);
    }

    @Override
    public void connect(JMXServiceURL url, Map<String, Object> env) throws IOException {
        Validate.notNull((Object)url, (String)"URL can't be NULL", (Object[])new Object[0]);
        if (this.connection != null) {
            throw new IllegalStateException("Session is already opened");
        }
        JMXConnector connector = this.doConnect(url, env);
        this.connection = new ConnectionImpl(connector, url);
    }

    @Override
    public void disconnect() throws IOException {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.close();
        }
        finally {
            this.connection = null;
        }
    }

    protected JMXConnector doConnect(JMXServiceURL url, Map<String, Object> env) throws IOException {
        return JMXConnectorFactory.connect(url, env);
    }

    @Override
    public Connection getConnection() {
        if (this.connection == null) {
            throw new IllegalStateException("Connection isn't open yet. Run open command to open a connection");
        }
        return this.connection;
    }

    @Override
    public boolean isConnected() {
        return this.connection != null;
    }
}

