/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.jdk5;

import java.io.IOException;
import org.apache.commons.lang3.Validate;
import org.cyclopsgroup.jmxterm.JavaProcess;
import org.cyclopsgroup.jmxterm.jdk5.ConnectorAddressLink;

class Jdk5JavaProcess
implements JavaProcess {
    private final String command;
    private final ConnectorAddressLink connectorAddressLink;
    private final int processId;
    private String url;

    Jdk5JavaProcess(int processId, String command, ConnectorAddressLink connectorAddressLink) {
        Validate.isTrue((processId > 0 ? 1 : 0) != 0, (String)("Invalid process ID " + processId), (Object[])new Object[0]);
        Validate.notNull((Object)command, (String)"Command line can't be NULL", (Object[])new Object[0]);
        Validate.notNull((Object)connectorAddressLink, (String)"connectorAddressLink can't be NULL", (Object[])new Object[0]);
        this.processId = processId;
        this.command = command;
        this.connectorAddressLink = connectorAddressLink;
    }

    @Override
    public String getDisplayName() {
        return this.command;
    }

    @Override
    public int getProcessId() {
        return this.processId;
    }

    @Override
    public boolean isManageable() {
        return this.url != null;
    }

    @Override
    public void startManagementAgent() throws IOException {
        if (this.url != null) {
            return;
        }
        this.url = this.connectorAddressLink.importFrom(this.processId);
    }

    @Override
    public String toUrl() {
        return this.url;
    }
}

