/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.lang3.Validate;

public class ConfigurationUtils {
    public static Configuration loadFromOverlappingResources(String resourcePath, ClassLoader classLoader) throws IOException {
        Validate.notNull((Object)resourcePath, (String)"Resource path can't be NULL", (Object[])new Object[0]);
        Validate.notNull((Object)classLoader, (String)"ClassLoader can't be NULL", (Object[])new Object[0]);
        PropertiesConfiguration props = new PropertiesConfiguration();
        props.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        Enumeration<URL> resources = classLoader.getResources(resourcePath);
        while (resources.hasMoreElements()) {
            InputStream resource = resources.nextElement().openStream();
            try (InputStreamReader reader = new InputStreamReader(resource);){
                props.read((Reader)reader);
            }
        }
        return props;
    }

    private ConfigurationUtils() {
    }
}

