/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.format;

import org.cyclopsgroup.caff.format.AlignPolicy;
import org.cyclopsgroup.caff.format.FormatException;

public enum TrimPolicy {
    FORWARD{

        @Override
        CharSequence trim(CharSequence src, int length, AlignPolicy align) {
            CharSequence truncated;
            if (src.length() <= length) {
                throw new AssertionError((Object)("Length of source[" + src.length() + " must be greater than " + length));
            }
            switch (align) {
                case LEFT: {
                    truncated = src.subSequence(0, length);
                    break;
                }
                case RIGHT: {
                    truncated = src.subSequence(src.length() - length, src.length());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("No such thing " + (Object)((Object)align)));
                }
            }
            return truncated;
        }
    }
    ,
    REVERSE{

        @Override
        CharSequence trim(CharSequence src, int length, AlignPolicy align) {
            CharSequence truncated;
            if (src.length() <= length) {
                throw new AssertionError((Object)("Length of source[" + src.length() + " must be greater than " + length));
            }
            switch (align) {
                case LEFT: {
                    truncated = src.subSequence(src.length() - length, src.length());
                    break;
                }
                case RIGHT: {
                    truncated = src.subSequence(0, length);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("No such thing " + (Object)((Object)align)));
                }
            }
            return truncated;
        }
    }
    ,
    DISALLOW{

        @Override
        CharSequence trim(CharSequence src, int length, AlignPolicy align) {
            if (src.length() <= length) {
                throw new AssertionError((Object)("Length of source[" + src.length() + " must be greater than " + length));
            }
            throw new FormatException("Value [" + src + "] is bigger than available space " + length);
        }
    };


    abstract CharSequence trim(CharSequence var1, int var2, AlignPolicy var3);
}

