/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.io;

import java.io.PrintStream;
import org.apache.commons.lang3.Validate;
import org.cyclopsgroup.jmxterm.io.CommandOutput;

public class PrintStreamCommandOutput
extends CommandOutput {
    private final PrintStream messageOutput;
    private final PrintStream resultOutput;

    public PrintStreamCommandOutput() {
        this(System.out);
    }

    public PrintStreamCommandOutput(PrintStream output) {
        this(output, System.err);
    }

    public PrintStreamCommandOutput(PrintStream resultOutput, PrintStream messageOutput) {
        Validate.notNull(resultOutput, "Result output can't be NULL", new Object[0]);
        Validate.notNull(messageOutput, "Message output can't be NULL", new Object[0]);
        this.resultOutput = resultOutput;
        this.messageOutput = messageOutput;
    }

    @Override
    public void print(String output) {
        this.resultOutput.print(output);
    }

    @Override
    public void printError(Throwable e) {
        e.printStackTrace(this.messageOutput);
    }

    @Override
    public void printMessage(String message) {
        this.messageOutput.println(message);
    }
}

