/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.lang3.Validate;
import org.cyclopsgroup.jcli.annotation.Argument;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.SyntaxUtils;
import org.cyclopsgroup.jmxterm.cmd.BeansCommand;
import org.cyclopsgroup.jmxterm.cmd.DomainCommand;
import org.cyclopsgroup.jmxterm.cmd.DomainsCommand;
import org.cyclopsgroup.jmxterm.io.RuntimeIOException;

@Cli(name="bean", description="Display or set current selected MBean. ", note="Without any parameter, it displays current selected bean, otherwise it selects the bean defined by the first parameter. eg. bean java.lang:type=Memory")
public class BeanCommand
extends Command {
    private String bean;
    private String domain;

    public static String getBeanName(String bean, String domain, Session session) throws JMException, IOException {
        String domainName;
        Validate.notNull((Object)session, (String)"Session can't be NULL", (Object[])new Object[0]);
        if (bean == null) {
            return session.getBean();
        }
        if (SyntaxUtils.isNull(bean)) {
            return null;
        }
        MBeanServerConnection con = session.getConnection().getServerConnection();
        if (bean.indexOf(58) != -1) {
            try {
                ObjectName name = new ObjectName(bean);
                con.getMBeanInfo(name);
                return bean;
            }
            catch (MalformedObjectNameException name) {
            }
            catch (InstanceNotFoundException name) {
                // empty catch block
            }
        }
        if ((domainName = DomainCommand.getDomainName(domain, session)) == null) {
            throw new IllegalArgumentException("Please specify domain using either -d option or domain command");
        }
        try {
            ObjectName name = new ObjectName(domainName + ":" + bean);
            con.getMBeanInfo(name);
            return domainName + ":" + bean;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Bean name " + bean + " isn't valid");
    }

    static List<String> getCandidateBeanNames(Session session) throws MalformedObjectNameException {
        try {
            ArrayList<String> results = new ArrayList<String>(BeansCommand.getBeans(session, null));
            String domain = session.getDomain();
            if (domain != null) {
                List<String> beans = BeansCommand.getBeans(session, domain);
                for (String bean : beans) {
                    results.add(bean.substring(domain.length() + 1));
                }
            }
            return results;
        }
        catch (IOException e) {
            throw new RuntimeIOException("Couldn't find candidate bean names", e);
        }
    }

    @Override
    public List<String> doSuggestArgument() throws IOException, MalformedObjectNameException {
        return BeanCommand.getCandidateBeanNames(this.getSession());
    }

    @Override
    public List<String> doSuggestOption(String optionName) throws IOException {
        if (optionName.equals("d")) {
            return DomainsCommand.getCandidateDomains(this.getSession());
        }
        return null;
    }

    @Override
    public void execute() throws IOException, JMException {
        Session session = this.getSession();
        if (this.bean == null) {
            if (session.getBean() == null) {
                session.output.println("null");
            } else {
                session.output.println(session.getBean());
            }
            return;
        }
        String beanName = BeanCommand.getBeanName(this.bean, this.domain, session);
        if (beanName == null) {
            session.setBean(null);
            session.output.printMessage("bean is unset");
            return;
        }
        ObjectName name = new ObjectName(beanName);
        MBeanServerConnection con = session.getConnection().getServerConnection();
        con.getMBeanInfo(name);
        session.setBean(beanName);
        session.output.printMessage("bean is set to " + beanName);
    }

    @Argument(displayName="bean", description="MBean name with or without domain")
    public final void setBean(String bean) {
        this.bean = bean;
    }

    @Option(name="d", longName="domain", description="Domain name")
    public final void setDomain(String domain) {
        this.domain = domain;
    }
}

